local function isMusicOn() return nRes(5) == 1 end

function main(self)
    local claw = GetClaw()

    if self.State == 0 then
        if self.arcanis then
            if isMusicOn() then SetMusic"SILENCE" end
            self.Flags.AlwaysActive = true
            self.arcanis.SpeedX, self.arcanis.SpeedY = 0, 0 -- freeze Boss
            self.lastClawHitType = claw.HitTypeFlags
            claw.HitTypeFlags = 0
            self.lastClawState = claw.State
            claw.State = ClawStates.Freeze
            SetRespawnPoint(self.arcanis.XTweak, self.arcanis.YTweak + 100)
            PlaySound"CUSTOM_ARCANIS_DIE"
            CameraToObject(self)
            self.timeCounter = GetTime() + 2200
            self.mapPieceDestX = self.arcanis.XTweak
            self.mapPieceDestY = self.arcanis.YTweak
            self.State = 1
        end
    end

    if self.State == 1 and GetTime() > self.timeCounter then -- wait for a sound to stop
        self.arcanis.State = 211 -- Arcanis STATE.DEFEATED
        self.arcanis:SetFrame(201)
        self.arcanis.AttackFlags.Player = false
        self.arcanis.HitFlags.Player = false
        self.arcanis.BumpFlags.Enemy = false
        self.timeCounter = GetTime() + 400
        self.State = 2
    end

    if self.State == 2 and GetTime() > self.timeCounter then
        self.mapPieceDummy = CreateHUDObject{
            X = PlayAreaRect.Right/2 + 1,
            Y = PlayAreaRect.Bottom/2 + 1,
            Z = 10000,
            logic = "DoNothing",
            image = "GAME_MAPPIECE"
        }
        CameraToPoint(self.mapPieceDestX, self.mapPieceDestY) -- camera to Map Piece destination
        self.timeCounter = GetTime() + 2000
        self.timeLimit = GetTime() + 5000
        PlaySound"GAME_AMULETRISE"
        self.State = 3
    end

    if self.State == 3 and GetTime() > self.timeCounter then
        local screenCenter = GetCameraPoint()
        local goalPos = screenCenter.X == self.mapPieceDestX and screenCenter.Y == self.mapPieceDestY
        if goalPos or GetTime() > self.timeLimit or GetClaw().Health <= 0 then
            CreateObject{
                X = self.mapPieceDestX,
                Y = self.mapPieceDestY,
                Z = 2000,
                logic = "SpecialPowerup",
                image = "GAME_MAPPIECE"
            }
            self.mapPieceDummy:Destroy()
            self.State = 5
        end
    end

    if self.State == 5 and GetTime() > self.timeCounter then
        CameraToClaw() -- camera back to Claw
        UnblockClaw()
        claw.HitTypeFlags = self.lastClawHitType
        if self.lastClawState == ClawStates.Jump then
            claw.State = ClawStates.Fall
            claw.PhysicsType = PhysicsTypes.Fall
        else
            claw.State = self.lastClawState
        end
        self:Destroy()
    end
end